/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import icyllis.modernui.core.event.OpenMenuEvent;
import icyllis.modernui.core.forge.ModernUIForge;
import icyllis.modernui.core.forge.MuiHooks;
import icyllis.modernui.core.forge.MuiRegistries;
import icyllis.modernui.core.forge.ProjectBuilderModel;
import icyllis.modernui.graphics.BlurHandler;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.test.TestMenu;
import icyllis.modernui.test.TestUI;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.VideoSettingsScreen;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
final class EventHandler {
    EventHandler() {
    }

    @SubscribeEvent
    static void onRightClickItem(@Nonnull PlayerInteractEvent.RightClickItem event) {
        if (ModernUIForge.isDeveloperMode() && event.getSide().isServer() && event.getItemStack().func_77973_b() == Items.field_151045_i) {
            MuiHooks.openMenu(event.getPlayer(), TestMenu::new);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="modernui", value={Dist.CLIENT})
    static class Client {
        static SliderPercentageOption NEW_GUI_SCALE;
        @Nullable
        private static Screen sCapturedVideoSettingsScreen;

        Client() {
        }

        @SubscribeEvent
        static void onPlayerLogin(@Nonnull ClientPlayerNetworkEvent.LoggedInEvent event) {
            ClientPlayerEntity player;
            if (ModernUIForge.isDeveloperMode() && (player = event.getPlayer()) != null && RenderCore.glCapabilitiesErrors > 0) {
                player.func_145747_a((ITextComponent)new StringTextComponent("[Modern UI] There are " + RenderCore.glCapabilitiesErrors + " GL capabilities that are not supported by your GPU, see debug.log for detailed info").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        static void onGuiOpenH(@Nonnull GuiOpenEvent event) {
            if (ModernUIForge.interceptTipTheScales && event.getGui() instanceof VideoSettingsScreen) {
                sCapturedVideoSettingsScreen = event.getGui();
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        static void onGuiOpenL(@Nonnull GuiOpenEvent event) {
            BlurHandler.INSTANCE.count(event.getGui());
            if (sCapturedVideoSettingsScreen != null) {
                event.setGui(sCapturedVideoSettingsScreen);
                sCapturedVideoSettingsScreen = null;
            }
        }

        @SubscribeEvent
        static void onGuiInit(@Nonnull GuiScreenEvent.InitGuiEvent event) {
            if (event.getGui() instanceof VideoSettingsScreen) {
                NEW_GUI_SCALE.func_216728_a((float)(MuiHooks.C.calcGuiScales() & 0xF));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModClientExp {
        ModClientExp() {
        }

        @SubscribeEvent
        static void onRegistryModel(@Nonnull ModelRegistryEvent event) {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("modernui", "item/project_builder_main"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("modernui", "item/project_builder_cube"));
        }

        @SubscribeEvent
        static void onBakeModel(@Nonnull ModelBakeEvent event) {
            Map registry = event.getModelRegistry();
            ModClientExp.replaceModel(registry, new ModelResourceLocation(Objects.requireNonNull(MuiRegistries.PROJECT_BUILDER_ITEM.getRegistryName()), "inventory"), m3 -> new ProjectBuilderModel((IBakedModel)m3, event.getModelLoader()));
        }

        private static void replaceModel(@Nonnull Map<ResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation location, @Nonnull Function<IBakedModel, IBakedModel> factory) {
            modelRegistry.put((ResourceLocation)location, factory.apply(modelRegistry.get(location)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="modernui", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    static class ModClient {
        ModClient() {
        }

        @SubscribeEvent
        static void onOpenMenu(@Nonnull OpenMenuEvent event) {
            if (event.getMenu().func_216957_a() == MuiRegistries.TEST_MENU) {
                event.setScreen(new TestUI());
            }
        }
    }
}

